#ifndef Gate_INPUT_H
#define Gate_INPUT_H

#include "GlobalDefines.h"
#include "Gate_BASE.h"

class Gate_INPUT : public Gate_BASE
{
    Q_OBJECT
    public:
        Gate_INPUT(int gateID, gType type,
                 int numInputs, int gateLevel);

        void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);
        void simulateToOutput();

    signals:

    public slots:
        void promptValue();
        void promptFaultyValue();

    protected:
        void contextMenuEvent(QGraphicsSceneContextMenuEvent *event);

    private:
        void createActions();
        QAction *setInputValueAction;
        QAction *setFaultValueAction;

};

#endif // Gate_INPUT_H
